/** @file   saveslot.h
 * @brief   Declaration of SaveSlot - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_SAVESLOT_H
#define H_WWW_SAVESLOT_H

#include <string>


namespace WeWantWar {

/** @class  SaveSlot
 * @brief   Represents a savefile slot.
 * @author  Tomi Lamminsaari
 *
 * The game has 6 saveslots. Each of these saveslots are modelled by an
 * instance of this class. It checks if certain slot is empty or not and
 * defines the correct filename for the slot.
 */
class SaveSlot
{
public:

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructs a saveslot.
   * @param     num               The slot number (0..5)
   */
  SaveSlot(int num);
  
  /** A copy constructor.
   * @param   rO                  Another SaveSlot.
   */
  SaveSlot(const SaveSlot& rO);
  
  /** Destructor.
   */
  ~SaveSlot();
  
  /** Operator =
   */
  SaveSlot& operator = (const SaveSlot& rO);



  ///
  /// Public GET-methods
  /// ==================
  
  /** Returns the filename of this saveslot.
   * @return    Name of the file that has the contents of this saveslot.
   */
  std::string getSlotFile() const;
  
  /** Returns the levelnumber of the game in this saveslot.
   * @return    THe levelnumber or -1 if this slot is empty.
   */
  int         getSlotContent() const;
  

protected:

  ///
  /// Members
  /// =======

  /** The sequence number of this slot. */
  int           m_slotnum;
  /** Name of the savefile. */
  std::string   m_slotFile;
  /** The levelnumber of the saved game. */
  int           m_slotContent;
};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: saveslot.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:13+02  lamminsa
 * Initial revision
 *
 */
